/*=============================================================================*
*リモートキーヤー サーバ用ファームウェア Ver2.1
*Copyright (C) 2019-2025 NAGAO, Toshitsugu(JF5SIM)
*アマチュア無線家による利用は改変、再配布を含め自由とします。
*本プログラムを運用して生じたいかなる結果に対しても、著作権者は一切の責任を負いません。
*=============================================================================*/

#include <avr/wdt.h>
#include <MsTimer2.h>
#include <TimerOne.h>
#include <SPI.h>
#include <Ethernet.h>
#include <EthernetUdp.h>
#define SAMPLING_INTERVAL 5000 //キー接点のサンプリング周期　5000ナノ秒 = 5ミリ秒ごとにサンプリング
#define DATA_PKT_ARRIVAL_INTERVAL  40 //クライアントからデータが送られてくる間隔（ミリ秒）
#define SEL_NO1_TRX 0x01

/*===================================================================*
*ネットワーク関連設定　ここから
*お持ちのイーサネットシールドやネットワーク環境に合わせて設定してください。
*===================================================================*/
//イーサネットシールドのMACアドレスの登録
byte mac[] = {0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX};

//自局のNW設定
IPAddress ip(192, 168, 0, 9);
IPAddress dns(192, 168, 0, 254);
IPAddress gateway(192, 168, 0, 254);
IPAddress subnet(255, 255, 255, 0);
unsigned int DataLocalPort = 8888; 

//通信先クライアントの指定
IPAddress DestIP(192, 168, 0, 16);
unsigned int DataDestPort = 8888; //必要がない限り変更しないでください。
/*===================================================================*
*ネットワーク関連設定　ここまで
*===================================================================*/

/*===================================================================*
*キーイングに使用するピンの設定　ここから
*本プログラムではArduino UnoのデジタルI/Oピンの8番と9番を使用します。
*必要に応じて変更してください。
*キーダウン時:HIGH キーアップ時:LOW
*===================================================================*/
const int keyPinTx1 = 8; //無線機1
const int keyPinTx2 = 9; //無線機2
/*===================================================================*
*キーイングに使用するピンの設定　ここまで
*===================================================================*/

EthernetServer server = EthernetServer(DataLocalPort);
EthernetUDP DataUdp;
int i = 0, j = 0;
int packetSize = 0;
byte key_buf1[UDP_TX_PACKET_MAX_SIZE];
byte key;
byte prevRigSelection;

//受信したパケットのデータをバッファに格納し、クライアントに応答パケットを返す関数
void RcvDataPacket(){
  packetSize = DataUdp.parsePacket();
  if(packetSize){
    //受信したパケットのデータをバッファに格納
    DataUdp.read(key_buf1, 2);
    //Serial.print(key_buf1[0], BIN);
    j++;
    if(j > 5){ //クライアントからのパケットを6個受信すると、クライアントに応答パケットを返す。
      DataUdp.beginPacket(DestIP, DataDestPort);
      DataUdp.write(0xFF);
      DataUdp.endPacket();
      j = 0;
    }
  }else{
    //クライアントからのパケットが途絶した場合、強制的にキーUP状態にする。この処理がないと連続送信になるおそれがある。
    digitalWrite(keyPinTx1, LOW);
    //PORTB &= ~ 0b00000001;
    digitalWrite(keyPinTx2, LOW);
    //PORTB &= ~ 0b00000010;
  }
}

//受信したデータに従ってキーイングを行う関数
void Keying(){
  key = key_buf1[0];
  //前回実行時と無線機の選択が変わっていた場合、前回実行時に選択されていた無線機向けの
  //キーイングピンをキーUPにする。
  if(prevRigSelection != key_buf1[1]){
    digitalWrite(keyPinTx1, LOW);
    //PORTB &= ~ 0b00000001;
    digitalWrite(keyPinTx2, LOW);
    //PORTB &= ~ 0b00000010;
  }
  //キーイング処理
  if(packetSize){
    key = key >> i;
    if(key & 0x01){
      if(key_buf1[1] == SEL_NO1_TRX){
        digitalWrite(keyPinTx1, HIGH);
        //PORTB |= 0b00000001;
        //Serial.print("1");
      }else{
        digitalWrite(keyPinTx2, HIGH);
        //PORTB |= 0b00000010;
      }
    }
    else{
      if(key_buf1[1] == SEL_NO1_TRX){
        digitalWrite(keyPinTx1, LOW);
        //PORTB &= ~ 0b00000001;
        //Serial.print("0");
      }else{
        digitalWrite(keyPinTx2, LOW);
        //PORTB &= ~ 0b00000010;
      }
    }
    i++;
  }
  if(i > 7) i = 0;
  prevRigSelection = key_buf1[1];
}

void setup() {
  //通信の設定
  Serial.begin(115200);
  Ethernet.begin(mac, ip, dns, gateway, subnet); 
  DataUdp.begin(DataLocalPort);
  
  //出力ピンの設定
  pinMode(keyPinTx1, OUTPUT);
  pinMode(keyPinTx2, OUTPUT);
  digitalWrite(keyPinTx1, LOW);
  //PORTB &= ~ 0b00000001;
  digitalWrite(keyPinTx2, LOW);
  //PORTB &= ~ 0b00000010;

  //Timer2
  MsTimer2::set(DATA_PKT_ARRIVAL_INTERVAL, RcvDataPacket);
  MsTimer2::start();

  //Timer1
  Timer1.initialize(SAMPLING_INTERVAL);
  Timer1.attachInterrupt(Keying);

  //WDT
  wdt_enable(WDTO_2S);
}

void loop() {
  wdt_reset();
}
