/*=============================================================================*
*リモートキーヤー クライアント用ファームウェア Ver2.1
*Copyright (C) 2019-2025 NAGAO, Toshitsugu(JF5SIM)
*アマチュア無線家による利用は改変、再配布を含め自由とします。
*本プログラムを運用して生じたいかなる結果に対しても、著作権者は一切の責任を負いません。
*=============================================================================*/

#include <avr/wdt.h>
#include <MsTimer2.h>
#include <TimerOne.h>
#include <SPI.h>
#include <Ethernet.h>
#define SAMPLING_INTERVAL 5000    //キー接点のサンプリング周期　5000ナノ秒 = 5ミリ秒ごとにサンプリング
#define PKT_ARRIVE_INTERVAL  200  //サーバからの応答パケットが返ってくる間隔（ミリ秒）
#define NOOPE_TIMELIMIT 2000      //無操作時間（ミリ秒） この時間を超過してキーイングが行われないとパケットの送信を停止する。

/*===================================================================*
*ネットワーク関連設定　ここから
*お持ちのイーサネットシールドやネットワーク環境に合わせて設定してください。
*===================================================================*/
//イーサネットシールドのMACアドレスの登録
byte mac[] = {0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX};

//自局のNW設定
IPAddress ip(192, 168, 0, 16);
IPAddress dns(192, 168, 0, 254);
IPAddress gateway(192, 168, 0, 254);
IPAddress subnet(255, 255, 255, 0);
unsigned int LocalPort = 8888; 

//通信先サーバの指定
IPAddress DestIP(192, 168, 0, 9);
unsigned int DestPort = 8888; //必要がない限り変更しないでください。
/*===================================================================*
*ネットワーク関連設定　ここまで
*===================================================================*/

/*===================================================================*
*使用するピンの設定　ここから
*本プログラムではArduino UnoのデジタルI/Oピンの7番から9番を使用します。
*必要に応じて変更してください。
*===================================================================*/
const int selTrx = 7; //無線機選択スイッチの入力ピン。LOWの場合無線機1、HIGHの場合無線機2が選択されているとして扱います。
const int keyPin = 8; //キーの入力ピン HIGH:キーダウン LOW:キーアップ として扱います。
const int monLed = 9; //サーバとの通信状態を表示するLEDの出力ピン。サーバからの応答パケットを受信するとHIGHになります。
/*===================================================================*
*使用するピンの設定　ここまで
*===================================================================*/

//無線機の選択定義
const int selNo1Trx = LOW;

//キーのUP/DOWNの定義
const int key_down = LOW;
const int key_up = HIGH;

EthernetUDP Udp;

bool send_pkt = true;
bool isNo1TrxSel =true;
int i = 0, j = 0;
int keyup_elapsed = 0;
int packetSize = 0;
byte key_buf1[2] = {0, 0};
byte key_buf = 0;

//キーのUP/DOWNをサンプリングしてUDPでサーバに送信する関数
/*void captureKey(){
  //if(digitalRead(keyPin) == key_down){
  if((PINB & 0b00000001) == key_down){ //処理を高速化するためにレジスタを直接操作している。意味はコメントアウトした上の行と同じ。
      delay(1);
      if((PINB & 0b00000001) == key_down){
        key_buf = key_buf | (1 << i); //キーダウン状態であれば、バッファのLSBを1にする。
        keyup_elapsed = 0; //無操作時間のカウンタをクリア
        send_pkt = true;//パケット送信許可フラグをtrueにする。
       }
  }else delay(1);
  i++;
  if(i > 6){ //7回目のサンプリングが終わったら、パケットの送信処理を行う。
    if(isNo1TrxSel){ //選択している無線機をサーバに通知するデータを設定
      key_buf = key_buf | (1 << 7);
    }else{
      key_buf = key_buf | (0 << 7);
    }
    if(send_pkt == true){ //パケットの送信処理
      Udp.beginPacket(DestIP, DestPort);
      Udp.write(key_buf);
      Udp.endPacket();
      Serial.println(key_buf, BIN);
    }
    //パケットの送信が終わったらバッファをクリアする。
    key_buf = 0;
    i = 0;
  }
}*/

//キーのUP/DOWNをサンプリングしてUDPでサーバに送信する関数
 void captureKey(){
  //if(digitalRead(keyPin) == key_down){
  if((PINB & 0b00000001) == key_down){ //処理を高速化するためにレジスタを直接操作している。意味はコメントアウトした上の行と同じ。
      delay(1);
      if((PINB & 0b00000001) == key_down){
        key_buf1[0] = key_buf1[0] | (1 << i); //キーダウン状態であれば、バッファのLSBを1にする。
        keyup_elapsed = 0; //無操作時間のカウンタをクリア
        send_pkt = true;//パケット送信許可フラグをtrueにする。
       }
  }else delay(1);
  i++;
  if(i > 7){ //8回目のサンプリングが終わったら、パケットの送信処理を行う。
    if(isNo1TrxSel){ //選択している無線機をサーバに通知するデータを設定
      key_buf1[1] = 0x00;
    }else{
      key_buf1[1] = 0x01;
    }
    if(send_pkt == true){ //パケットの送信処理
      Udp.beginPacket(DestIP, DestPort);
      Udp.write(key_buf1, 2);
      Udp.endPacket();
      //Serial.println(key_buf1[0], BIN);
    }
    //パケットの送信が終わったらバッファをクリアする。
    key_buf1[0] = 0;
    key_buf1[1] = 0;
    i = 0;
  }
}

void monitoringAndControl(){
  //サーバから応答パケットが返ってきているか監視し、LEDに状態表示する。
  packetSize = Udp.parsePacket();
  if(packetSize){
    digitalWrite(monLed, HIGH);
  }else{
    digitalWrite(monLed, LOW);    
  }

  //電鍵の無操作時間を監視し、NOOPE_TIMELIMITに設定した時間を超えて操作がない場合は、パケットの送信フラグをfalseにしてパケットの送信を停止させる。
  if(send_pkt == true) keyup_elapsed++;
  if(keyup_elapsed > (NOOPE_TIMELIMIT / PKT_ARRIVE_INTERVAL))send_pkt = false;
    
  //無線機選択スイッチの状態を読み取り、結果をisNo1TrxSelに格納する。
  //if(digitalRead(selTrx) == selNo1Trx){
  if(((PIND>>7) & 0b00000001) == selNo1Trx){ 
    isNo1TrxSel = true;
  }else{
    isNo1TrxSel = false;
  }
}

void setup() {
  //通信関係の初期設定
  Serial.begin(19200);
  Ethernet.begin(mac, ip, dns, gateway, subnet);
  Udp.begin(LocalPort);
  
  //入出力ピンの初期設定
  pinMode(selTrx, INPUT_PULLUP);
  pinMode(keyPin, INPUT_PULLUP);
  pinMode(monLed, OUTPUT);

  //Timer2
  MsTimer2::set(PKT_ARRIVE_INTERVAL, monitoringAndControl);
  MsTimer2::start();
    
  //Timer1
  Timer1.initialize(SAMPLING_INTERVAL);
  Timer1.attachInterrupt(captureKey);

  //WDT
  wdt_enable(WDTO_2S);
}

void loop() {
  wdt_reset();
}
